ACTIVITY_TIMER_DEPTH = 500; -- depth value of timer
ACTIVITY_TIMER_POS = { x = 203, y = 545 }; -- position of the timer

function spawn_activity_timer()
	if scene[activity_timer_background_spec.name] == nil then
		scene:Spawn(activity_timer_background_spec);
	end
	
	if scene[activity_timer_bars_spec.name] == nil then
		scene:Spawn(activity_timer_bars_spec);
	end
	
	if scene[activity_timer_high_text_spec.name] == nil then
		scene:Spawn(activity_timer_high_text_spec);
	end
	
	if scene[activity_timer_mid_text_spec.name] == nil then
		scene:Spawn(activity_timer_mid_text_spec);
	end
	
	if scene[activity_timer_low_text_spec.name] == nil then
		scene:Spawn(activity_timer_low_text_spec);
	end
	
	if scene[activity_level_name_text_spec.name] == nil then
		scene:Spawn(activity_level_name_text_spec);
	end
	
	if scene[activity_timer_fill_spec.name] == nil then
		scene:Spawn(activity_timer_fill_spec);
	end
	
	if scene[activity_timer_display_spec.name] == nil then
		scene:Spawn(activity_timer_display_spec);
	end;
	
	if scene[activity_timer_spec.name] == nil then
		scene:Spawn(activity_timer_spec);
	end
	
	
	
	reset_activity_timer();
	start_activity_timer();
end

function kill_activity_timer()
	safe_kill_actor(scene[activity_timer_background_spec.name]);
	safe_kill_actor(scene[activity_timer_bars_spec.name]);
	safe_kill_actor(scene[activity_timer_high_text_spec.name]);
	safe_kill_actor(scene[activity_timer_mid_text_spec.name]);
	safe_kill_actor(scene[activity_timer_low_text_spec.name]);
	safe_kill_actor(scene[activity_level_name_text_spec.name]);
	safe_kill_actor(scene[activity_timer_fill_spec.name]);
	safe_kill_actor(scene[activity_timer_display_spec.name]);
	safe_kill_actor(scene[activity_timer_spec.name]);
end

function get_activity_time()
	return scene.ACTIVITY_TIMER.current_time - scene.ACTIVITY_TIMER.base_time;
end

function get_activity_score(level)
	local scoreratio = get_activity_time() / get_activity_bonus_time(level);
	
	if scoreratio < 1 then
		return ACTIVITY_BASE_SCORE + (1-scoreratio)*ACTIVITY_BONUS_SCORE_MAX;
	else
		return ACTIVITY_BASE_SCORE;
	end
end

function get_activity_total_score()
	local totalscore = 0;
	local activity_name = game:GetString("activity_mode_name");
	for i = 1,ACTIVITY_LEVEL_MAX do
		local score = game:Get(activity_name .. "_level_" .. i .. "_score");
		
		if score == nil then
			score = 0;
		end
		
		totalscore = totalscore + score;
	end
	
	return totalscore;
end

function start_activity_timer()
	scene.ACTIVITY_TIMER.running = true;
	reset_activity_timer();
	scene.ACTIVITY_TIMER:StartProc(activity_tick);
end

function reset_activity_timer()
	scene.ACTIVITY_TIMER.base_time = game:GetTime();
	scene.ACTIVITY_TIMER.current_time = game:GetTime();
end

function stop_activity_timer()
	if scene.ACTIVITY_TIMER then
		scene.ACTIVITY_TIMER.running = false;
	end
end

function activity_tick(actor)
	local activity_level = game:Get("activity_mode_level");
	local bonus_time = get_activity_bonus_time(activity_level);
	while actor.running do
		local cur_time = get_activity_time();
		if cur_time <= bonus_time then
			local bonus_amount = cur_time / bonus_time;
			scene.ACTIVITY_TIMER_FILL:SetScaleX(bonus_amount);
			
			local seconds = (bonus_time - cur_time) / 1000;
			local minutes = seconds / 60;
			seconds = fmod(seconds, 60);
			
			local timestring = string.format("%02d:%02d", minutes, seconds);
			
			scene.ACTIVITY_TIMER_DISPLAY:SayRaw(timestring);
		else
			scene.ACTIVITY_TIMER_FILL:SetScaleX(1);
			scene.ACTIVITY_TIMER_DISPLAY:SayRaw("00:00");
		end
		
		scene.ACTIVITY_TIMER.current_time = game:GetTime();
		delay(1);
	end
end

activity_timer_spec = 
{
	name = "ACTIVITY_TIMER";
	
	command = function(actor)
		actor.base_time = 0;
		actor.current_time = 0;
		actor.running = false;
	end;
}

activity_timer_display_spec = 
{
	name = "ACTIVITY_TIMER_DISPLAY";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+15);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
		
		actor:ModifySaySpec
		{
			color = { a = 1, r = 0, g = 0, b = 0 },
			color_over = { a = 1, r = 0, g = 0, b = 0 },
			bubble = false,
			lineheight = 30,
			outline_size = 0,
			x = 270,
			y = 20,
			w = 110,
			h = 30,
			font = "fonts/arial.mvec"; 
			anchor = ANCHOR.CENTER;
			halign = HALIGN.CENTER;
		};
		
		actor:SayRaw("00:00");
	end;
}

activity_timer_background_spec = 
{
	name = "ACTIVITY_TIMER_BACKGROUND";
	gfx = { image = "quest/activity_mode/activity_timer_background" };
	
	command = function(actor)
		--actor:SetDepthMode(DEPTH.FIXED);
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+5);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
	end;
};

activity_timer_bars_spec = 
{
	name = "ACTIVITY_TIMER_BARS";
	gfx = { image = "quest/activity_mode/activity_timer_bars" };
	
	command = function(actor)
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
	end;
}

activity_timer_fill_spec = 
{
	name = "ACTIVITY_TIMER_FILL";
	gfx = { image = "quest/activity_mode/activity_timer_fill" };
	
	command = function(actor)
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+1);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
	end;
}

activity_timer_text_spec = 
{
	color = { a = 1, r = 0, g = 0, b = 0 },
	color_over = { a = 1, r = 0, g = 0, b = 0 },
	bubble = false,
	lineheight = 17,
	outline_size = 0,
	y = 35,
	w = 90,
	h = 20,
	font = "fonts/arial.mvec"; 
	anchor = ANCHOR.CENTER;
	halign = HALIGN.CENTER;
}
activity_timer_text_spacingX = 80;

activity_timer_high_text_spec = 
{
	name = "ACTIVITY_TIMER_HIGH_TEXT";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+10);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
		
		actor:ModifySaySpec(activity_timer_text_spec)
		actor:ModifySaySpec
		{
			x = 0,
		};
		
		actor:Say("activity_bar_high");
	end;
}

activity_timer_mid_text_spec = 
{
	name = "ACTIVITY_TIMER_MID_TEXT";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+10);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
		
		actor:ModifySaySpec(activity_timer_text_spec)
		actor:ModifySaySpec
		{
			x = activity_timer_text_spacingX,
		};
		
		actor:Say("activity_bar_mid");
	end;
}

activity_timer_low_text_spec = 
{
	name = "ACTIVITY_TIMER_LOW_TEXT";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+10);
		actor:JumpToPoint(ACTIVITY_TIMER_POS);
		
		actor:ModifySaySpec(activity_timer_text_spec)
		actor:ModifySaySpec
		{
			x = activity_timer_text_spacingX*2,
		};
		
		actor:Say("activity_bar_low");
	end;
}

activity_level_name_text_spec = 
{
	name = "ACTIVITY_LEVEL_NAME_TEXT";
	
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_FIXED_SCREEN);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		actor:SetDepthValue(ACTIVITY_TIMER_DEPTH+10);
		actor:JumpToPoint{ x = ACTIVITY_TIMER_POS.x, y = ACTIVITY_TIMER_POS.y-48 };
		
		actor:ModifySaySpec(activity_timer_text_spec)
		actor:ModifySaySpec
		{
			x = activity_timer_text_spacingX,
			lineheight = 20,
		};
		
		actor:SayRaw("<b>" .. scene:grabstring("level") .. " " .. game:Get("activity_mode_level") .. "</b>");
	end;
}